#include <iostream>
#include <cstdio>
#include <vector>
#include <array>
#include <string>
#include <algorithm>
#include <numeric>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <queue>
#include <cmath>
#include <climits>
#include <iomanip>
#include <limits>
#include <tuple>
#include <stack>
#include <bitset>
#include <cstring>
#include <sstream>
#include <functional>
#include <random>
using namespace std;

using ll = long long; 

void solve() {
    int n;
    cin >> n;
    vector<pair<ll, ll>> pts(n);
    for (int i = 0; i < n; ++i) {
        cin >> pts[i].first;
    }
    for (int i = 0; i < n; ++i) {
        cin >> pts[i].second;
    }
    sort(pts.begin(), pts.end());
    vector<int> l(n), r(n), s;
    for (int i = 0; i < n; ++i) {
        while (!s.empty() && pts[s.back()].second < pts[i].second) {
            s.pop_back();
        }
        l[i] = s.empty() ? -1 : s.back();
        s.push_back(i);
    }
    s.clear();
    for (int i = n - 1; i >= 0; --i) {
        while (!s.empty() && pts[s.back()].second < pts[i].second) {
            s.pop_back();
        }
        r[i] = s.empty() ? -1 : s.back();
        s.push_back(i);
    }
    for (int i = 0; i < n; ++i) {
        ll x1 = pts[i].first, y1 = pts[i].second;
        ll ans = 1e9;
        if (r[i] != -1) {
            ll x2 = pts[r[i]].first, y2 = pts[r[i]].second;
            ans = min(ans, abs(x2 - x1 + y1 - y2));
        }
        if (l[i] != -1) {
            ll x2 = pts[l[i]].first, y2 = pts[l[i]].second;
            ans = min(ans, abs(x1 - y2 + y1 - x2));
        }
        cout << (ans == 1e9 ? -1 : ans) << '\n';
    }
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    solve();
    return 0;
}